<?php

namespace App\DTOs\AdvanceSalary;

use App\Enums\TravelStatusEnum;

class AdvanceSalaryFilterDTO
{
    public function __construct(
        public readonly ?int $companyId = null,
        public readonly ?int $employeeId = null,
        public readonly ?array $employeeIds = null,
        public readonly ?string $salaryType = null,
        public readonly ?int $status = null,
        public readonly ?string $monthYear = null,
        public readonly ?string $fromDate = null,
        public readonly ?string $toDate = null,
        public readonly int $perPage = 15,
        public readonly int $page = 1,
        public readonly string $search = "",
        public readonly string $sortBy = 'created_at',
        public readonly string $sortDirection = 'desc'
    ) {}

    public static function fromRequest(array $data): self
    {
        // Handle status conversion properly
        $status = null;
        // status can be string (pending/approved/rejected) or int (0/1/2)
        if (array_key_exists('status', $data) && $data['status'] !== null && $data['status'] !== '') {
            $inputStatus = is_numeric($data['status']) ? (int) $data['status'] : $data['status'];

            if ($inputStatus === 'approved' || $inputStatus === TravelStatusEnum::APPROVED->value) {
                $status = TravelStatusEnum::APPROVED->value;
            } else if ($inputStatus === 'rejected' || $inputStatus === TravelStatusEnum::REJECTED->value) {
                $status = TravelStatusEnum::REJECTED->value;
            } else if ($inputStatus === 'pending' || $inputStatus === TravelStatusEnum::PENDING->value) {
                $status = TravelStatusEnum::PENDING->value;
            } else {
                $status = null;
            }
        }


        return new self(
            companyId: isset($data['company_id']) ? (int) $data['company_id'] : null,
            employeeId: isset($data['employee_id']) ? (int) $data['employee_id'] : null,
            employeeIds: $data['employee_ids'] ?? null,
            salaryType: $data['type'] ?? $data['salary_type'] ?? null,
            status: $status,
            monthYear: $data['month_year'] ?? null,
            fromDate: $data['from_date'] ?? null,
            toDate: $data['to_date'] ?? null,
            perPage: (int) ($data['per_page'] ?? 15),
            page: (int) ($data['page'] ?? 1),
            search: $data['search'] ?? '',
            sortBy: $data['sort_by'] ?? 'created_at',
            sortDirection: $data['sort_direction'] ?? 'desc'
        );
    }

    public function toArray(): array
    {
        return [
            'company_id' => $this->companyId,
            'employee_id' => $this->employeeId,
            'employee_ids' => $this->employeeIds,
            'salary_type' => $this->salaryType,
            'status' => $this->status,
            'month_year' => $this->monthYear,
            'from_date' => $this->fromDate,
            'to_date' => $this->toDate,
            'per_page' => $this->perPage,
            'page' => $this->page,
            'search' => $this->search,
            'sort_by' => $this->sortBy,
            'sort_direction' => $this->sortDirection,
        ];
    }
}
