<?php

namespace App\DTOs\LeaveAdjustment;

use App\Models\LeaveAdjustment;
use Illuminate\Support\Facades\Log;

class CreateLeaveAdjustmentDTO
{
    public function __construct(
        public readonly int $companyId,
        public readonly int $employeeId,
        public readonly int $leaveTypeId,
        public readonly float $adjustHours,
        public readonly string $reasonAdjustment,
        public readonly string $adjustmentDate,
        public readonly ?int $status = null,
        public readonly ?int $createdBy = null // Added createdBy
    ) {}


    public static function fromRequest(array $data, int $companyId, int $employeeId, ?int $createdBy = null): self
    {
        return new self(
            companyId: $companyId,
            employeeId: $employeeId,
            leaveTypeId: (int)$data['leave_type_id'],
            adjustHours: (isset($data['operator']) && $data['operator'] === 'sub')
                ? -abs((float)$data['adjust_hours'])
                : abs((float)$data['adjust_hours']),
            reasonAdjustment: $data['reason_adjustment'],
            adjustmentDate: $data['adjustment_date'],
            createdBy: $createdBy
        );
    }
    public function toArray(): array
    {
        $data = [
            'company_id' => $this->companyId,
            'employee_id' => $this->employeeId,
            'leave_type_id' => $this->leaveTypeId,
            'adjust_hours' => (float)$this->adjustHours,
            'reason_adjustment' => $this->reasonAdjustment,
            'adjustment_date' => $this->adjustmentDate,
            'status' => $this->status ??  LeaveAdjustment::STATUS_PENDING,
            'created_at' => now(),
        ];

        return $data;
    }
}
