<?php

namespace App\DTOs\LeaveAdjustment;

use App\Models\User;

class LeaveAdjustmentFilterDTO
{
    public function __construct(
        public readonly ?string $companyName = null,
        public readonly ?int $companyId = null,
        public readonly ?int $employeeId = null,
        public readonly ?array $employeeIds = null,
        public readonly ?array $excludedLeaveTypeIds = null, // Exclude restricted leave types
        public readonly ?int $status = null,
        public readonly ?int $leaveTypeId = null,
        public readonly ?string $search = null,
        public readonly int $perPage = 15,
        public readonly int $page = 1,
        public readonly string $sortBy = 'created_at',
        public readonly string $sortDirection = 'desc'
    ) {}

    public static function fromRequest(array $data): self
    {
        // Handle status conversion properly
        $status = null;
        if (array_key_exists('status', $data) && $data['status'] !== null && $data['status'] !== '') {
            // Convert numeric strings to integers for proper comparison
            $inputStatus = is_numeric($data['status']) ? (int)$data['status'] : $data['status'];

            if ($inputStatus === 'approved' || $inputStatus === 1) {
                $status = 1;
            } else if ($inputStatus === 'rejected' || $inputStatus === 2) {
                $status = 2;
            } else if ($inputStatus === 'pending' || $inputStatus === 0) {
                $status = 0;
            }
        }

        return new self(
            companyName: $data['company_name'] ?? null,
            companyId: $data['company_id'] ?? null,
            employeeId: $data['employee_id'] ?? null,
            employeeIds: $data['employee_ids'] ?? null,
            excludedLeaveTypeIds: $data['excluded_leave_type_ids'] ?? null,
            status: $status,
            leaveTypeId: $data['leave_type_id'] ?? null,
            search: $data['search'] ?? null,
            perPage: (int) ($data['per_page'] ?? 15),
            page: (int) ($data['page'] ?? 1),
            sortBy: $data['sort_by'] ?? 'created_at',
            sortDirection: $data['sort_direction'] ?? 'desc'
        );
    }

    public function toArray(): array
    {
        return [
            'company_name' => $this->companyName,
            'company_id' => $this->companyId,
            'employee_id' => $this->employeeId,
            'employee_ids' => $this->employeeIds,
            'excluded_leave_type_ids' => $this->excludedLeaveTypeIds,
            'status' => $this->status,
            'leave_type_id' => $this->leaveTypeId,
            'search' => $this->search,
            'per_page' => $this->perPage,
            'page' => $this->page,
            'sort_by' => $this->sortBy,
            'sort_direction' => $this->sortDirection,
        ];
    }
}
