<?php

namespace App\DTOs\OfficeShift;

class CreateOfficeShiftDTO
{
    public function __construct(
        public readonly int $companyId,
        public readonly string $shiftName,
        public readonly string $mondayInTime,
        public readonly string $mondayOutTime,
        public readonly string $tuesdayInTime,
        public readonly string $tuesdayOutTime,
        public readonly string $wednesdayInTime,
        public readonly string $wednesdayOutTime,
        public readonly string $thursdayInTime,
        public readonly string $thursdayOutTime,
        public readonly string $fridayInTime,
        public readonly string $fridayOutTime,
        public readonly string $saturdayInTime,
        public readonly string $saturdayOutTime,
        public readonly string $sundayInTime,
        public readonly string $sundayOutTime,
        public readonly ?string $mondayLunchBreak = null,
        public readonly ?string $tuesdayLunchBreak = null,
        public readonly ?string $wednesdayLunchBreak = null,
        public readonly ?string $thursdayLunchBreak = null,
        public readonly ?string $fridayLunchBreak = null,
        public readonly ?string $saturdayLunchBreak = null,
        public readonly ?string $sundayLunchBreak = null,
        public readonly ?string $mondayLunchBreakOut = null,
        public readonly ?string $tuesdayLunchBreakOut = null,
        public readonly ?string $wednesdayLunchBreakOut = null,
        public readonly ?string $thursdayLunchBreakOut = null,
        public readonly ?string $fridayLunchBreakOut = null,
        public readonly ?string $saturdayLunchBreakOut = null,
        public readonly ?string $sundayLunchBreakOut = null,
        public readonly int $hoursPerDay,
        public readonly ?string $inTimeBeginning = null,
        public readonly ?string $inTimeEnd = null,
        public readonly ?int $lateAllowance = null,
        public readonly ?string $outTimeBeginning = null,
        public readonly ?string $outTimeEnd = null,
        public readonly ?string $breakStart = null,
        public readonly ?string $breakEnd = null,
    ) {}

    public static function fromRequest(array $data, int $companyId): self
    {
        return new self(
            companyId: $companyId,
            shiftName: $data['shift_name'],
            mondayInTime: $data['monday_in_time'] ?? '',
            mondayOutTime: $data['monday_out_time'] ?? '',
            tuesdayInTime: $data['tuesday_in_time'] ?? '',
            tuesdayOutTime: $data['tuesday_out_time'] ?? '',
            wednesdayInTime: $data['wednesday_in_time'] ?? '',
            wednesdayOutTime: $data['wednesday_out_time'] ?? '',
            thursdayInTime: $data['thursday_in_time'] ?? '',
            thursdayOutTime: $data['thursday_out_time'] ?? '',
            fridayInTime: $data['friday_in_time'] ?? '',
            fridayOutTime: $data['friday_out_time'] ?? '',
            saturdayInTime: $data['saturday_in_time'] ?? '',
            saturdayOutTime: $data['saturday_out_time'] ?? '',
            sundayInTime: $data['sunday_in_time'] ?? '',
            sundayOutTime: $data['sunday_out_time'] ?? '',
            mondayLunchBreak: $data['monday_lunch_break'] ?? null,
            tuesdayLunchBreak: $data['tuesday_lunch_break'] ?? null,
            wednesdayLunchBreak: $data['wednesday_lunch_break'] ?? null,
            thursdayLunchBreak: $data['thursday_lunch_break'] ?? null,
            fridayLunchBreak: $data['friday_lunch_break'] ?? null,
            saturdayLunchBreak: $data['saturday_lunch_break'] ?? null,
            sundayLunchBreak: $data['sunday_lunch_break'] ?? null,
            mondayLunchBreakOut: $data['monday_lunch_break_out'] ?? null,
            tuesdayLunchBreakOut: $data['tuesday_lunch_break_out'] ?? null,
            wednesdayLunchBreakOut: $data['wednesday_lunch_break_out'] ?? null,
            thursdayLunchBreakOut: $data['thursday_lunch_break_out'] ?? null,
            fridayLunchBreakOut: $data['friday_lunch_break_out'] ?? null,
            saturdayLunchBreakOut: $data['saturday_lunch_break_out'] ?? null,
            sundayLunchBreakOut: $data['sunday_lunch_break_out'] ?? null,
            hoursPerDay: (int) ($data['hours_per_day'] ?? 8),
            inTimeBeginning: $data['in_time_beginning'] ?? null,
            inTimeEnd: $data['in_time_end'] ?? null,
            lateAllowance: isset($data['late_allowance']) ? (int) $data['late_allowance'] : null,
            outTimeBeginning: $data['out_time_beginning'] ?? null,
            outTimeEnd: $data['out_time_end'] ?? null,
            breakStart: $data['break_start'] ?? null,
            breakEnd: $data['break_end'] ?? null,
        );
    }

    public function toArray(): array
    {
        return [
            'company_id' => $this->companyId,
            'shift_name' => $this->shiftName,
            'monday_in_time' => $this->mondayInTime,
            'monday_out_time' => $this->mondayOutTime,
            'tuesday_in_time' => $this->tuesdayInTime,
            'tuesday_out_time' => $this->tuesdayOutTime,
            'wednesday_in_time' => $this->wednesdayInTime,
            'wednesday_out_time' => $this->wednesdayOutTime,
            'thursday_in_time' => $this->thursdayInTime,
            'thursday_out_time' => $this->thursdayOutTime,
            'friday_in_time' => $this->fridayInTime,
            'friday_out_time' => $this->fridayOutTime,
            'saturday_in_time' => $this->saturdayInTime,
            'saturday_out_time' => $this->saturdayOutTime,
            'sunday_in_time' => $this->sundayInTime,
            'sunday_out_time' => $this->sundayOutTime,
            'monday_lunch_break' => $this->mondayLunchBreak,
            'tuesday_lunch_break' => $this->tuesdayLunchBreak,
            'wednesday_lunch_break' => $this->wednesdayLunchBreak,
            'thursday_lunch_break' => $this->thursdayLunchBreak,
            'friday_lunch_break' => $this->fridayLunchBreak,
            'saturday_lunch_break' => $this->saturdayLunchBreak,
            'sunday_lunch_break' => $this->sundayLunchBreak,
            'monday_lunch_break_out' => $this->mondayLunchBreakOut,
            'tuesday_lunch_break_out' => $this->tuesdayLunchBreakOut,
            'wednesday_lunch_break_out' => $this->wednesdayLunchBreakOut,
            'thursday_lunch_break_out' => $this->thursdayLunchBreakOut,
            'friday_lunch_break_out' => $this->fridayLunchBreakOut,
            'saturday_lunch_break_out' => $this->saturdayLunchBreakOut,
            'sunday_lunch_break_out' => $this->sundayLunchBreakOut,
            'hours_per_day' => $this->hoursPerDay,
            'in_time_beginning' => $this->inTimeBeginning,
            'in_time_end' => $this->inTimeEnd,
            'late_allowance' => $this->lateAllowance,
            'out_time_beginning' => $this->outTimeBeginning,
            'out_time_end' => $this->outTimeEnd,
            'break_start' => $this->breakStart,
            'break_end' => $this->breakEnd,
            'created_at' => date('Y-m-d H:i:s'),
        ];
    }
}
