<?php

namespace App\Http\Requests\Employee;

use Illuminate\Foundation\Http\FormRequest;

class UpdateFamilyDataRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'relative_full_name' => 'nullable|string|max:255',
            'relative_email' => 'nullable|email|max:255',
            'relative_phone' => 'nullable|string|max:20|regex:/^[0-9+\-\s()]+$/',
            'relative_place' => 'nullable|string|max:255',
            'relative_address' => 'nullable|string|max:500',
            'relative_relation' => 'nullable|string|max:100'
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'relative_full_name.string' => 'اسم القريب يجب أن يكون نص',
            'relative_full_name.max' => 'اسم القريب يجب أن يكون أقل من 255 حرف',
            'relative_email.email' => 'بريد القريب الإلكتروني يجب أن يكون صحيح',
            'relative_email.max' => 'بريد القريب الإلكتروني يجب أن يكون أقل من 255 حرف',
            'relative_phone.string' => 'هاتف القريب يجب أن يكون نص',
            'relative_phone.max' => 'هاتف القريب يجب أن يكون أقل من 20 حرف',
            'relative_phone.regex' => 'رقم هاتف القريب غير صحيح',
            'relative_place.string' => 'مكان القريب يجب أن يكون نص',
            'relative_place.max' => 'مكان القريب يجب أن يكون أقل من 255 حرف',
            'relative_address.string' => 'عنوان القريب يجب أن يكون نص',
            'relative_address.max' => 'عنوان القريب يجب أن يكون أقل من 500 حرف',
            'relative_relation.string' => 'صلة القرابة يجب أن تكون نص',
            'relative_relation.max' => 'صلة القرابة يجب أن تكون أقل من 100 حرف'
        ];
    }
}