<?php

declare(strict_types=1);

namespace App\Http\Requests\Report;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class ExpiringContractsReportRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'end_date' => 'required|date_format:Y-m-d',
        ];
    }

    public function attributes(): array
    {
        return [
            'end_date' => 'تاريخ الانتهاء قبل',
        ];
    }

    public function messages()
    {
        return [
            'end_date.required' => 'يجب اختيار تاريخ الانتهاء قبل',
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'success' => false,
            'message' => 'فشل التحقق من البيانات',
            'errors' => $validator->errors(),
        ], 422));
    }
}
